/*
 * @(#)AbstractObject.java  2.1  2006-03-20
 *
 * Copyright (c) 2003 Lucerne University of Applied Sciences and Arts (HSLU)
 * Zentralstrasse 18, Postfach 2858, CH-6002 Lucerne, Switzerland
 * All rights reserved.
 *
 * The copyright of this software is owned by the Lucerne University of Applied 
 * Sciences and Arts (HSLU). You may not use, copy or modify this software, 
 * except in accordance with the license agreement you entered into with HSLU. 
 * For details see accompanying license terms. 
 */

package ch.hslu.cm.simulation;

import javax.swing.event.*;
import java.util.*;
import java.beans.*;
import org.jhotdraw.beans.AbstractBean;
/**
 * AbstractObject.
 *
 *
 * @author Werner Randelshofer
 * @version 2.1 2006-03-20 Method getSimulatedElements(int) added.
 * <br>2.0 2006-02-15 Upgraded to Java 1.5 type safe collectins.
 * <br>1.0 2. Dezember 2003  Created.
 */
public abstract class AbstractObject
        extends AbstractBean
        implements SimulatedObject {
    
    protected EventListenerList listenerList = new EventListenerList();
    private Simulation simulation;
    protected String name;
    
    /** Creates a new instance. */
    public AbstractObject() {
    }
    public void setName(String newValue) {
        String oldValue = name;
        name = newValue;
        firePropertyChange("name", oldValue, newValue);
    }
    public String getName() {
        return name;
    }
    
    public void addNotify(Simulation simulation) {
        this.simulation = simulation;
        fireAddedToSimulation();
    }
    
    public void removeNotify(Simulation simulation) {
        fireRemovedFromSimulation();
        this.simulation = null;
    }
    
    public Simulation getSimulation() {
        return simulation;
    }
    
    // LISTENER SUPPORT
    /**
     * Adds a listener for SimulatedObjectEvent's.
     */
    public void addSimulatedObjectListener(SimulatedObjectListener l) {
        listenerList.add(SimulatedObjectListener.class, l);
    }
    
    /**
     * Removes a listener for SimulatedObjectEvent's.
     */
    public void removeSimulatedObjectListener(SimulatedObjectListener l) {
        listenerList.remove(SimulatedObjectListener.class, l);
    }
    
    /**
     * Notify all listeners that have registered interest for
     * notification on this event type.  The event instance
     * is lazily created using the parameters passed into
     * the fire method.
     */
    protected void fireStateChanged() {
        if (listenerList != null) {
            SimulatedObjectEvent event = null;
            
            // Guaranteed to return a non-null array
            Object[] listeners = listenerList.getListenerList();
            // Process the listeners last to first, notifying
            // those that are interested in this event
            for (int i = listeners.length-2; i>=0; i-=2) {
                if (listeners[i]==SimulatedObjectListener.class) {
                    // Lazily create the event:
                    if (event == null)
                        event = new SimulatedObjectEvent(this);
                    ((SimulatedObjectListener)listeners[i+1]).objectChanged(event);
                }
            }
        }
    }
    /**
     * Notify all listeners that have registered interest for
     * notification on this event type.  The event instance
     * is lazily created using the parameters passed into
     * the fire method.
     */
    protected void fireAddedToSimulation() {
        if (listenerList != null) {
            SimulatedObjectEvent event = null;
            
            // Guaranteed to return a non-null array
            Object[] listeners = listenerList.getListenerList();
            // Process the listeners last to first, notifying
            // those that are interested in this event
            for (int i = listeners.length-2; i>=0; i-=2) {
                if (listeners[i]==SimulatedObjectListener.class) {
                    // Lazily create the event:
                    if (event == null)
                        event = new SimulatedObjectEvent(this);
                    ((SimulatedObjectListener)listeners[i+1]).objectAdded(event);
                }
            }
        }
    }
    /**
     * Notify all listeners that have registered interest for
     * notification on this event type.  The event instance
     * is lazily created using the parameters passed into
     * the fire method.
     */
    protected void fireRemovedFromSimulation() {
        if (listenerList != null) {
            SimulatedObjectEvent event = null;
            
            // Guaranteed to return a non-null array
            Object[] listeners = listenerList.getListenerList();
            // Process the listeners last to first, notifying
            // those that are interested in this event
            for (int i = listeners.length-2; i>=0; i-=2) {
                if (listeners[i]==SimulatedObjectListener.class) {
                    // Lazily create the event:
                    if (event == null)
                        event = new SimulatedObjectEvent(this);
                    ((SimulatedObjectListener)listeners[i+1]).objectRemoved(event);
                }
            }
        }
    }
    /**
     * Notify all listeners that have registered interest for
     * notification on this event type.  The event instance
     * is lazily created using the parameters passed into
     * the fire method.
     */
    protected void fireObjectRequestRemove() {
        if (listenerList != null) {
            SimulatedObjectEvent event = null;
            
            // Guaranteed to return a non-null array
            Object[] listeners = listenerList.getListenerList();
            // Process the listeners last to first, notifying
            // those that are interested in this event
            for (int i = listeners.length-2; i>=0; i-=2) {
                if (listeners[i]==SimulatedObjectListener.class) {
                    // Lazily create the event:
                    if (event == null)
                        event = new SimulatedObjectEvent(this);
                    ((SimulatedObjectListener)listeners[i+1]).objectRequestRemove(event);
                }
            }
        }
    }
    
    /**
     * Creates a shallow copy of this element.
     */
    public AbstractObject clone() {
            AbstractObject that = (AbstractObject) super.clone();
            that.listenerList = new EventListenerList();
            that.simulation = null;
            return that;
    }
    
    public String toString() {
        return (getName() == null) ? super.toString() : getName();
    }
    
    public boolean isEquivalent(SimulatedObject that) {
        if (that.getSimulatedConcept() == this.getSimulatedConcept() &&
                (that.getName() == null && this.getName() == null ||
                that.getName() != null && this.getName() != null &&
                that.getName().equals(this.getName()))
        
        ) {
            return true;
        }
        return false;
    }
}
